/*

(  ___  )(  ____ \(  ____ \   ( \      \__   __/(  ____ \\__   __/
| (   ) || (    \/| (    \/   | (         ) (   | (    \/   ) (
| (___) || |      | |         | |         | |   | (__       | |
|  ___  || |      | |         | |         | |   |  __)      | |
| (   ) || |      | |         | |         | |   | (         | |
| )   ( || (____/\| (____/\   | (____/\___) (___| )         | |
|/     \|(_______/(_______/   (_______/\_______/|/          )_(

ACC_Lift filterscript for SA:MP 0.3d by Mike

Feel free to modify and distribute this as you wish.

Version: 1.0

Changelogs

2.0:

- Moved to an include
- Added defines for lift IDs (LIFT_MAIN and LIFT_SIDE)
- Added an option to disable the test commands (/lift and /sidelift) - see USE_TRYME
- TO-DO: Added sounds when lifts are moving
- TO-DO: Added ACC_StopLift(lift) to stop a lift at it's current position
- TO-DO: Added ACC_GetLiftPos(lift, &Float:liftx, &Float:lifty, &Float:liftz) - Returns the position of the lift object
- TO-DO: Added ACC_DeleteLifts() - Deletes the lifts
- TO-DO: Added ACC_GetLiftObjectID(lift) - Returns the object ID of the lifts
- TO-DO: Updated for new MoveObject behaviour in 0.3d RC5

1.0: Initial release.

*/

#define REMOVE_OBJECTS // Removing this line will disable THIS SCRIPT from removing the default lifts. Please see the topic for this filterscript for more info
#define USE_TRYME // Remove this line to disable /sidelift and /list (or comment it out)

#include <a_samp>

#define LIFT_STATUS_UP 0
#define LIFT_STATUS_LOWERING 1
#define LIFT_STATUS_RISING 2
#define LIFT_STATUS_DOWN 3

#define LIFT_MAIN 0
#define LIFT_SIDE 1

new lift_object_id[2];
new lift_status[2];

new Float:lift_coords[2][6] = { // xyz for raised pos, xyz for lowered pos
{-1456.700805, 501.301513, 16.903375, -1456.700805, 501.301513, 9.863378}, // Main lift
{-1414.450439, 516.463256, 16.679367, -1414.450439, 516.463256, 9.649368} // Side lift
};

public OnFilterScriptInit()
{
        #if defined REMOVE_OBJECTS
        for(new i=0; i<GetMaxPlayers(); i++)
        {
            if(!IsPlayerConnected(i)) continue;
                RemoveBuildingForPlayer(i, 3114, -1430.3319,503.3230,19.7853, 123); // Aircraft Carrier Lift
                RemoveBuildingForPlayer(i, 3115, -1430.3319,503.3230,19.7853, 123); // Aircraft Carrier Lift
        }
        #endif

        lift_object_id[0] = CreateObject(3115, -1456.714721, 501.301513, 16.914375, 0.000000, 0.000000, 0.000000);
        lift_object_id[1] = CreateObject(3114, -1414.450439, 516.463256, 16.679368, 0.000000, 0.000000, 0.000000);
        return 1;
}

public OnFilterScriptExit()
{
        DestroyObject(lift_object_id[0]);
        DestroyObject(lift_object_id[1]);
        return 1;
}

public OnPlayerConnect(playerid)
{
        #if defined REMOVE_OBJECTS
        RemoveBuildingForPlayer(playerid, 3114, -1430.3319,503.3230,19.7853, 123); // Aircraft Carrier Lift
        RemoveBuildingForPlayer(playerid, 3115, -1430.3319,503.3230,19.7853, 123); // Aircraft Carrier Lift
        #endif
        return 1;
}

stock ACC_MoveLift(lift, updown=-1, Float:speed=1.0)
{
        if(lift != 0 && lift != 1)
        {
                printf("Invalid lift ID passed to ACC_MoveLift (%i)", lift);
                return -1;
        }

        new Float:lift_speed = speed;
        if(speed == 0.0) lift_speed = 1.0; // If speed was set to 0, set it to 1

        if(lift == 0)
        {
                switch(updown)
                {
                    case -1: // Move depending on current status
                    {
                        if(lift_status[0] == LIFT_STATUS_UP || lift_status[0] == LIFT_STATUS_RISING) // If it's rising or up
                        {
                            StopObject(lift_object_id[0]);
                            MoveObject(lift_object_id[0], lift_coords[0][3], lift_coords[0][4], lift_coords[0][5], lift_speed); // Lower it
                            lift_status[0] = LIFT_STATUS_LOWERING;
                        }
                        else // It's down or lowering, raise it
                        {
                            StopObject(lift_object_id[0]);
                            MoveObject(lift_object_id[0], lift_coords[0][0], lift_coords[0][1], lift_coords[0][2], lift_speed); // Raise it
                            lift_status[0] = LIFT_STATUS_RISING;
                        }
                    }
                    case 0, 2: // Raise
                    {
                        print("Raising.");
                    }
                        case 1, 3: // Lower
                        {
                            print("Lowering.");
                        }
                        default: printf("Invalid 'updown' value passed to ACC_Move_Lift.", updown);
                }
        }
        else
        {
                switch(updown)
                {
                    case -1: // Move depending on current status
                    {
                        if(lift_status[1] == LIFT_STATUS_UP || lift_status[1] == LIFT_STATUS_RISING) // If it's rising or up
                        {
                            StopObject(lift_object_id[1]);
                            MoveObject(lift_object_id[1], lift_coords[1][3], lift_coords[1][4], lift_coords[1][5], lift_speed); // Lower it
                            lift_status[1] = LIFT_STATUS_LOWERING;
                        }
                        else // It's down or lowering, raise it
                        {
                            StopObject(lift_object_id[1]);
                            MoveObject(lift_object_id[1], lift_coords[1][0], lift_coords[1][1], lift_coords[1][2], lift_speed); // Raise it
                            lift_status[1] = LIFT_STATUS_RISING;
                        }
                    }
                    case 0, 2: // Raise
                    {
                        StopObject(lift_object_id[1]);
                                MoveObject(lift_object_id[1], lift_coords[1][0], lift_coords[1][1], lift_coords[1][2], lift_speed); // Raise it
                                lift_status[1] = LIFT_STATUS_RISING;
                    }
                        case 1, 3: // Lower
                        {
                            StopObject(lift_object_id[1]);
                                MoveObject(lift_object_id[1], lift_coords[1][3], lift_coords[1][4], lift_coords[1][5], lift_speed); // Lower it
                                lift_status[1] = LIFT_STATUS_LOWERING;
                        }
                        default: printf("Invalid 'updown' value passed to ACC_Move_Lift.", updown);
                }
        }
        return 1;
}

stock ACC_GetLiftStatus(lift)
{
        if(lift != 0 && lift != 1)
        {
            printf("Invalid lift ID passed to ACC_MoveLift (%i)", lift);
            return -1;
        }
        return lift_status[lift];
}

public OnObjectMoved(objectid)
{
        if(objectid == lift_object_id[0])
        {
                if(lift_status[0] == LIFT_STATUS_RISING) lift_status[0] = LIFT_STATUS_UP;
                else  lift_status[0] = LIFT_STATUS_DOWN;
        }
        else if(objectid == lift_object_id[1])
        {
                if(lift_status[1] == LIFT_STATUS_RISING) lift_status[1] = LIFT_STATUS_UP;
                else  lift_status[1] = LIFT_STATUS_DOWN;
        }
}

#if defined USE_TRYME

// Example usage:

#define dcmd(%1,%2,%3) if((strcmp((%3)[1], #%1, true, (%2)) == 0) && ((((%3)[(%2) + 1] == 0) && (dcmd_%1(playerid, "")))||(((%3)[(%2) + 1] == 32) && (dcmd_%1(playerid, (%3)[(%2) + 2]))))) return 1
#define ACC_COLOR 0x148b8bFF

public OnPlayerCommandText(playerid, cmdtext[])
{
        dcmd(lift, 4, cmdtext);
        dcmd(sidelift, 8, cmdtext);
        return 0;
}

dcmd_lift(playerid, params[])
{
        ACC_MoveLift(0, -1, floatstr(params));
        if(ACC_GetLiftStatus(0) == LIFT_STATUS_RISING) SendClientMessage(playerid, ACC_COLOR, "Lift rising.");
        else SendClientMessage(playerid, ACC_COLOR, "Lift lowering.");
        return 1;
}

dcmd_sidelift(playerid, params[])
{
        ACC_MoveLift(1, -1, floatstr(params));
        if(ACC_GetLiftStatus(1) == LIFT_STATUS_RISING) SendClientMessage(playerid, ACC_COLOR, "Side lift rising.");
        else SendClientMessage(playerid, ACC_COLOR, "Side lift lowering.");
        return 1;
}

#endif
